<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\AirCraft;
use App\AirCraftData;
use App\Aircraft_type;
use App\Manufacturer;
use App\Aircraft_model;
use App\Variant;
use App\Flightpadaircraft;
use App\Flightaircraft;
use DB;
use Excel;
use Validator;
// use Maatwebsite\Excel\Facades\Excel;


class FlightpadaircraftController extends Controller
{
    public function createFlightpadaircraft(){
        $types = Aircraft_type::get();
    	return view('admin.flightpadaircrafts.create_flightpadaircraft')
            ->with('types',$types);
    }

    
    public function flightpadaircrafts(Request $request){
        // $manufacturers = Manufacturer::all();
        $manufacturers = Flightaircraft::groupBy('manufacturer')->pluck('manufacturer');
        $categories = Flightaircraft::groupBy('category')->pluck('category');
        if($request->isMethod('post')){
            $category = $request->category;
            $manufacturer = $request->manufacturer;
            if($category=='all_val' && $manufacturer=='all_val'){
                $data = Flightaircraft::orderBy('position','ASC')->get();
            }
            elseif ($category=='all_val' && $manufacturer!='all_val') {
                $data = Flightaircraft::where('manufacturer',$manufacturer)->orderby('position','ASC')->get();
            }
            elseif ($category!='all_val' && $manufacturer=='all_val') {
                $data = Flightaircraft::where('category',$category)->orderby('position','ASC')->get();
            }
            elseif($category!='all_val' && $manufacturer!='all_val'){
                $data = Flightaircraft::where('category',$category)->where('manufacturer',$manufacturer)->orderby('position','ASC')->get();
            }
            $res['success'] = 1;
            $res['data'] = $data;
            $view = view("admin.flightpadaircrafts.partial_flightpadaircrafts",compact('data','manufacturers','categories'))->render();
            return response()->json(['html'=>$view]);
        }
        else{
        	$data = Flightaircraft::orderby('position','ASC')->get();
        	return view('admin.flightpadaircrafts.flightpadaircrafts')
        		->with('data',$data)
                ->with('manufacturers',$manufacturers)
                ->with('categories',$categories);
        }
    }

    public function storeFlightpadaircraft(Request $request){
    	$new = new Flightaircraft;
        if($request->has('category') && $request->get('category')!='' && $request->get('category')!=null){
            $new->category = $request->get('category');
        }
        if($request->has('id_backend') && $request->get('id_backend')!='' && $request->get('id_backend')!=null){
        	$new->id_backend = $request->get('id_backend');
        }
       
        if($request->has('type') && $request->get('type')!='' && $request->get('type')!=null){
            $new->type = $request->get('type');
        }
       
        if($request->has('manufacturer') && $request->get('manufacturer')!='' && $request->get('manufacturer')!=null){
            $new->manufacturer = $request->get('manufacturer');
        }
        
        if($request->has('model') && $request->get('model')!='' && $request->get('model')!=null){
            $new->model = $request->get('model');
        }
       
        if($request->has('display_manufacturer') && $request->get('display_manufacturer')!='' && $request->get('display_manufacturer')!=null){
            $new->display_manufacturer = $request->get('display_manufacturer');
        }
       
         if($request->has('display_name') && $request->get('display_name')!='' && $request->get('display_name')!=null){
            $new->display_name = $request->get('display_name');
        }
        
         if($request->has('variant') && $request->get('variant')!='' && $request->get('variant')!=null){
            $new->variant = $request->get('variant');
        }
       
         if($request->has('call_sign') && $request->get('call_sign')!='' && $request->get('call_sign')!=null){
            $new->callsign = $request->get('call_sign');
        }
        if($request->has('unit') && $request->get('unit')!='' && $request->get('unit')!=null){
            $new->unit = $request->get('unit');
        }
         if($request->has('bew') && $request->get('bew')!='' && $request->get('bew')!=null){
            $new->BEW = $request->get('bew');
        }
        if($request->has('moment_long') && $request->get('moment_long')!='' && $request->get('moment_long')!=null){
            $new->moment_long = $request->get('moment_long');
        }
       
        if($request->has('moment_lat') && $request->get('moment_lat')!='' && $request->get('moment_lat')!=null){
            $new->moment_lat = $request->get('moment_lat');
        }
       
        if($request->has('mtow') && $request->get('mtow')!='' && $request->get('mtow')!=null){
            $new->MTOW = $request->get('mtow');
        }
        if($request->has('max_fuel') && $request->get('max_fuel')!='' && $request->get('max_fuel')!=null){
            $new->max_fuel = $request->get('max_fuel');
        }
        if($request->has('description_line1') && $request->get('description_line1')!='' && $request->get('description_line1')!=null){
            $new->description_line1 = $request->get('description_line1');
        }
         if($request->has('description_line2') && $request->get('description_line2')!='' && $request->get('description_line2')!=null){
            $new->description_line2 = $request->get('description_line2');
        }
        if($request->has('version') && $request->get('version')!='' && $request->get('version')!=null){
            $new->version = $request->get('version');
        }
       if($request->has('internal_remarks') && $request->get('internal_remarks')!='' && $request->get('internal_remarks')!=null){
            $new->internal_remarks = $request->get('internal_remarks');
        }
       if($request->has('image') && $request->get('image')!='' && $request->get('image')!=null){
            $new->image_name = $request->get('image');
        }
        $data = Flightaircraft::orderBy('position','DESC')->first();
        if($data){
            $new->position = $data->position + 1;
        }
    	$new->save();
    	return redirect('/flightpadaircrafts');
    }

    public function deleteFlightpadaircraft(Request $request){
        $id = $request->id;
        $flighpadaircraft = Flightaircraft::find($id);
        $flighpadaircraft->delete();
        if($flighpadaircraft->image_name && file_exists(public_path('flightpadaircraft_images').'/'.$flighpadaircraft->image_name)){
            unlink(public_path('/flightpadaircraft_images').'/'.$flighpadaircraft->image_name);
        }
        $res['success'] = 1;
        return json_encode($res);
    }
    public function editFlightpadaircraft(Request $request){
        $id = $request->id;
        $flightpadaircraft = Flightaircraft::find($id);
        $types = Aircraft_type::get();
        $res['data'] = $flightpadaircraft;
        $res['types'] = $types;
        return json_encode($res);
    }

    public function updateFlightPadAircraft(Request $request){
        $id = $request->edit_id2;
        $flightpadaircraft = Flightaircraft::find($id);
        $flightpadaircraft->category = $request->category1;
        $flightpadaircraft->id_backend = $request->id_backend1;
        $flightpadaircraft->type = $request->type1;
        $flightpadaircraft->manufacturer = $request->manufacturer1;
        $flightpadaircraft->model = $request->model1;
        $flightpadaircraft->display_manufacturer = $request->display_manufacturer1;
        $flightpadaircraft->display_name = $request->display_name1;
        $flightpadaircraft->variant = $request->variant1;
        $flightpadaircraft->unit = $request->unit1;
        $flightpadaircraft->BEW = $request->bew1;
        $flightpadaircraft->moment_long = $request->long1;
        $flightpadaircraft->moment_lat = $request->lat1;
        $flightpadaircraft->MTOW = $request->mtow1;
        $flightpadaircraft->max_fuel = $request->fuel1;
        $flightpadaircraft->description_line1 = $request->desc1;
        $flightpadaircraft->description_line2 = $request->desc2;
        $flightpadaircraft->version = $request->ver1;
        $flightpadaircraft->internal_remarks = $request->remarks1;
        $flightpadaircraft->image_name = $request->image1;
        $flightpadaircraft->internal_remarks = $request->rem1;
        $flightpadaircraft->callsign = $request->callsign1;
        $flightpadaircraft->save();

        $category = $request->category_val;
        $manufacturer = $request->manufacturer_val;
        if($category=='all_val' && $manufacturer=='all_val'){
            $data = Flightaircraft::orderBy('position','ASC')->get();
        }
        elseif ($category=='all_val' && $manufacturer!='all_val') {
            $data = Flightaircraft::where('manufacturer',$manufacturer)->orderby('position','ASC')->get();
        }
        elseif ($category!='all_val' && $manufacturer=='all_val') {
            $data = Flightaircraft::where('category',$category)->orderby('position','ASC')->get();
        }
        elseif($category!='all_val' && $manufacturer!='all_val'){
            $data = Flightaircraft::where('category',$category)->where('manufacturer',$manufacturer)->orderby('position','ASC')->get();
        }
        $res['success'] = 1;
        $res['data'] = $data;
        $view = view("admin.flightpadaircrafts.partial_flightpadaircrafts",compact('data'))->render();
        return response()->json(['html'=>$view]);

    }
    public function changeRowOrders(Request $request){
        $position = $request->position;
        $i=1;
        foreach($position as $id){
            $flightpadaircraft = Flightaircraft::find($id);
            $flightpadaircraft->position = $i;
            $flightpadaircraft->save();
            // $sql = "Update sorting_items SET position_order=".$i." WHERE id=".$v;
            // $mysqli->query($sql);
            $i++;
        }
    }



    public function upload_excel(Request $request){
        $rules = [
            'file' => 'required|mimes:csv,txt',
        ];
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
            return $this->validate($request,$rules);
        }
        $upload=$request->file('file');
        $filePath=$upload->getRealPath();
        $file=fopen($filePath, 'r');
        $header= fgetcsv($file);
        $escapedHeader=[];
        //validate
        $column_count = count($header);
        foreach ($header as $key => $value) {
            $lheader=strtolower($value);
            $escapedItem=preg_replace('/[^a-z]/', '', $lheader);
            array_push($escapedHeader, $escapedItem);
        }
        // return $header;
        if($header[0]!='Image Name' || $column_count!=20 || $header[19]!='Remarks'){
            return back()->with('warning', 'The file should have headers like: "Image Name","Category","ID backend","Type","Manufacturer","Model","Display Manufacturer","Display Name","Variant","Callsign","Unit","BEW","Moment Long","Moment Lat","MTOW (kg or lbs)","Max Fuel (gal or liter)","Description Line1","Description Line2","Version","Remarks"');
        }
        //looping through othe columns
        while($columns=fgetcsv($file))
        { 
            $length = count($columns);
            if($columns[0]=="")
            {
                continue;
            }
            $flightaircraft = new Flightaircraft;
            $flightaircraft->image_name = $columns[0];
            $flightaircraft->category = $columns[1];
            $flightaircraft->id_backend = $columns[2];
            $flightaircraft->type = $columns[3];
            $flightaircraft->manufacturer = $columns[4];
            $flightaircraft->model = $columns[5];
            $flightaircraft->display_manufacturer = $columns[6];
            $flightaircraft->display_name = $columns[7];
            $flightaircraft->variant = $columns[8];
            $flightaircraft->callsign = $columns[9];
            $flightaircraft->unit = $columns[10];
            $flightaircraft->BEW = $columns[11];
            $flightaircraft->moment_long = $columns[12];
            $flightaircraft->moment_lat = $columns[13];
            $flightaircraft->MTOW = $columns[14];
            $flightaircraft->max_fuel = $columns[15];
            $flightaircraft->description_line1 = $columns[16];
            $flightaircraft->description_line2 = $columns[17];
            $flightaircraft->version = $columns[18];
            $flightaircraft->internal_remarks = $columns[19];
            $data = Flightaircraft::orderBy('position','DESC')->first();
            if($data){
                $flightaircraft->position = $data->position + 1;
            }else{
                $flightaircraft->position = 1;
            }
            $flightaircraft->save();
        }
        
        return back()->with('success', 'CSV Data Imported successfully.');
    
    }
    /**
   * @OA\Get( path="/api/flightpadaircraftlistnew",
   * summary = "to get response from database",
   *  tags={"Flightpad"},
 *      @OA\Parameter(
   *        name="AppKey", in="header",required=true, 
   *          @OA\Schema(type="string",)
   *     ),
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getFlightPadAircraftsnew(Request $request){
      //  $appkey = $request->header('AppKey');
      //  $userAppkey= config('constants.AuthKey');
        
      // if($userAppkey == $appkey){
        $flightpadaircrafts = Flightaircraft::all();
        $res['success'] = 1;
        $res['data'] = $flightpadaircrafts;
     //  }else {
      //  $res['fail'] = "authentication Fail";
     //  }
        return $res;
    }

/**
   * @OA\Get( path="/api/flightpadaircraftlist",
   * summary = "to get response from database",
   *  tags={"unsecure Api"},
 
   * @OA\RequestBody(
   *       required=false,
   *       @OA\MediaType(
   *           mediaType="application/xml",
   *       )
   *   ),
   * @OA\Response(response="200", description="An example resource"),
   * @OA\Response(response="404", description="Not found"),
   * 
   * )
   */
    public function getFlightPadAircrafts( Request $request){
  
        $flightpadaircrafts = Flightaircraft::all();
        $res['success'] = 1;
        $res['data'] = $flightpadaircrafts;
       
        
        return $res;
    }
 
    public function excel_to_csv($in_file, $out_file) {

        if( !$fr = @fopen($in_file, "r") ) die("Failed to open file");

        $fw = fopen($out_file, "w");

        while( ($data = fgetcsv($fr, 1000, ",")) !== FALSE ) {

            foreach( array_keys($data) as $key )

            $data[$key] = '"' . str_replace('"', '""', $data[$key]) . '"';

            $line = implode(",", $data) . "n";

            fwrite($fw, $line);

        }

        fclose($fr);

        fclose($fw);

    }
}
