<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateConfigurationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('configurations', function (Blueprint $table) {
            $table->integer('configurations_id',11);
            $table->string('config_name',100);
            $table->integer('aircraft_type');
            $table->integer('manufacturer');
            $table->integer('model');
            $table->integer('variant');
            $table->text('image2');
            $table->integer('box_width');
            $table->integer('box_height');
            $table->float('cacwidth',10,5);
            $table->float('cacheight',10,5);
            $table->float('cacy',10,5);
            $table->float('cacx',10,5);
            $table->text('remark');
            $table->datetime('created_at');
            $table->datetime('updated_at');
            $table->string('fwd_top_px',10);
            $table->string('fwd_left_px',10);
            $table->string('aft_top_px',10);
            $table->string('aft_left_px',10);
            $table->string('x1_top_px',10);
            $table->string('x1_left_px',10);
            $table->string('x2_top_px',10);
            $table->string('x2_left_px',10);
            $table->string('cweightunits',50);
            $table->integer('cmaxramp');
            $table->integer('cmaxtow');
            $table->integer('cmaxldw');
            $table->string('ccalclateralfuel',100);
            $table->string('cfuelunits',50);
            $table->float('ctankmaxfuelvolume',10,5);
            $table->double('cfactorlbsgal');
            $table->double('cfactorkgliter');
            $table->string('centermode',6);
            $table->integer('cfuelflowlbsperh');
            $table->integer('cpresetmain');
            $table->integer('cpresetlanding');
            $table->integer('cquickloadpreset');
            $table->integer('cyupheliindividual');
            $table->integer('yupheliplan');
            $table->string('swapoffon',5);
            $table->string('cquickcrew',5);
            $table->string('cidwidwn',50);
            $table->string('ccolorcode',50);
            $table->string('cflightlegs',50);
            $table->float('clongarmfrontseat',10,5);
            $table->float('clongarmrearseat',10,5);
            $table->float('ckeeptozero',10,5);
            $table->float('clatarmrightseat',10,5);
            $table->float('cseatsfront',10,5);
            $table->float('cseatsrear',10,5);
            $table->integer('cseatwidth');
            $table->integer('cseatheight');
            $table->string('clatcenter',50);
            $table->string('clatright',50);
            $table->integer('cfuelpanelheight');
            $table->string('cfuelpanelstart',50);
            $table->string('clargetopview',50);
            $table->string('cconfigequiplabel',50);
            $table->text('cspecialmanifest');
            $table->string('csetupoptions',50);
            $table->string('cdateuseu',50);
            $table->integer('cpickerminuteinterval');
            $table->string('cpickerlocale',50);
            $table->integer('cconfigstationsstart');
            $table->integer('cconfigstationsend');
            $table->string('cmanifestexport',50);
            $table->string('csummaryexport',50);
            $table->string('callowinteroredit',50);
            $table->string('ccheckmargin',50);
            $table->integer('cmarginpercent');
            $table->string('csecondcgenvelope',50);
            $table->integer('clinepilot');
            $table->string('ccalcmaxexternalorhoist',50);
            $table->string('callowequipchange',50);
            $table->string('cfwdaftcgcheck',50);
            $table->integer('cauxfuelvolume');
            $table->string('cdateformat',30);
            $table->text('cfltdataelements');
            $table->string('callowbewoverride',50);
            $table->string('clockresetifnotsent',50);
            $table->string('cifunitsaremeter',50);
            $table->string('csetlineasfreeload',50);
            $table->string('cportlandboth',50);
            $table->string('criskassess',50);
            $table->string('cdocviewer',50);
            $table->string('cintconfigurator',50);
            $table->string('callsign',50);
            $table->string('unit',50);
            $table->string('mass',50);
            $table->string('lonsta',50);
            $table->string('lonmom',50);
            $table->string('latsta',50);
            $table->string('latmom',50);
            $table->string('ccheckacupdates',5);
            $table->string('cboxalpha',50);
            $table->string('cslideralpha',50);
            $table->string('cboxgap',50);
            $table->string('ctopypos',50);
            $table->string('cboxstyle',50);
            $table->string('ccgexternal',50);
            $table->integer('cperfbuttonwidth');
            $table->string('cboxedsliders',50);
            $table->tinyInteger('is_locked')->default('1');
            $table->integer('copy_from_id');
            $table->string('client_email',300);
            $table->string('selectorbuttons',100);
            $table->string('factorcrewweight',100);
            $table->string('flighttypes',100);
            $table->string('supplyfuelvolume',100);
            $table->string('subtractsupplyfuel',100);
            $table->string('secondmaxavailtext',100);
            $table->string('dependsondisplaybutton',100);
            $table->string('maxavailonmanifest',100);
            $table->string('fuelpresets',100);
            $table->string('autolandingfuelpreset',100);
            $table->text('extra1');
            $table->text('extra2');
            $table->text('extra3');
            $table->text('extra4');
            $table->text('extra5');
            $table->text('extra6');
            $table->text('extra7');
            $table->text('extra8');
            $table->text('extra9');
            $table->text('extra10');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('configurations');
    }
}
