<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcAllavailableacdatabaseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ac_allavailableacdatabase', function (Blueprint $table) {
            $table->integer('id',11);
            $table->integer('ac_aircraft_id')->nullable();
            $table->integer('ac_manufacturer_id')->nullable();
            // $table->foreign('ac_manufacturer_id')->references('manufacture_id ')->on('ac_manufacturer')->onDelete('cascade');
            $table->integer('ac_model_id')->nullable();
            // $table->foreign('ac_model_id')->references('model_id')->on('ac_model')->onDelete('cascade');
            $table->integer('ac_variant_id')->nullable();
            // $table->foreign('ac_variant_id')->references('variant_id')->on('ac_variant')->onDelete('cascade');
            $table->string('display_name')->nullable();
            $table->integer('is_deleted');
            $table->datetime('created_at');
            $table->datetime('updated_at');
            $table->datetime('deleted_at');
            $table->foreign('ac_manufacturer_id')->references('manufacture_id')->on('ac_manufacturer')->onDelete('cascade');
            $table->foreign('ac_model_id')->references('model_id')->on('ac_model')->onDelete('cascade');
            $table->foreign('ac_variant_id')->references('variant_id')->on('ac_variant')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ac_allavailableacdatabase');
    }
}
