<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAircraftDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('airCraft_data', function (Blueprint $table) {
            $table->increments('acd_id',10);
            $table->integer('ac_id');
            $table->integer('basic_empty_weight');
            $table->string('mm_long',20);
            $table->string('mm_lat',20);
            $table->text('cg_envelope');
            $table->text('fuel_interpolation');
            $table->text('available_charts');
            $table->text('interior_config');
            $table->text('cg_envelope_name');
            $table->text('fuel_interpolation_name');
            $table->text('available_charts_name');
            $table->text('interior_config_name');
            $table->integer('unit');
            $table->float('version',10,5);
            $table->integer('m_to_w');
            $table->float('fuel',10,5);
            $table->string('category',200);
            $table->text('thub_name');
            $table->text('topview_name');
            $table->text('desc_1');
            $table->text('desc_2');
            $table->text('remarks');
            $table->tinyInteger('is_locked')->default('1');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('airCraft_data');
    }
}
