<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCgEnvelopesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cg_envelopes', function (Blueprint $table) {
            $table->increments('envelope_id',11);
            $table->string('envelope_name',100);
            $table->integer('aircraft_type');
            $table->integer('manufacturer');
            $table->integer('model');
            $table->integer('variant');
            $table->integer('box_width');
            $table->integer('box_height');
            $table->text('remark');
            $table->string('unit',50);
            $table->float('x_min',10,2)->nullable();
            $table->float('x_max',10,2)->nullable();
            $table->float('y_min',10,2)->nullable();
            $table->float('y_max',10,2)->nullable();
            $table->integer('x_line')->nullable();
            $table->integer('y_line')->nullable();
            $table->tinyInteger('is_locked')->default('1');
            $table->datetime('created_at');
            $table->datetime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cg_envelopes');
    }
}
