<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateComponentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('components', function (Blueprint $table) {
            $table->increments('id',11);
            $table->integer('config_id');
            $table->foreign('config_id')->references('configurations_id')->on('configurations')->onDelete('cascade');
            $table->float('ilongarm');
            $table->float('ilatarm');
            $table->integer('item_id');
            $table->float('isymbolwidth')->default('45');
            $table->float('isymbolheight')->default('50');
            $table->float('irotation');
            $table->float('ilongoffset');
            $table->float('ilatoffset');
            $table->string('iseatlabel',500);
            $table->string('iseatsymbol',500);
            $table->string('ispecials',500)->nullable();
            $table->string('part_id',500);
            $table->string('istationname',500)->default('name');
            $table->float('iweight');
            $table->float('ioccweight');
            $table->float('ionoff');
            $table->float('imaxweight')->default('300');
            $table->string('ioccname',500);
            $table->string('ileftright',500)->default('0');
            $table->string('iarmalternate',500);
            $table->integer('ilatmom')->default('0');
            $table->integer('ilongmom')->default('0');
            $table->integer('sequence')->default('1');
            $table->integer('status');
            $table->string('type',10);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('components');
    }
}
