@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="{{route('cgEnvelope')}}">CG Envelope</a></li>
               <li class="breadcrumb-item"><a class="active-color" href="#">CG Envelope Edit</a>
               </li>
           </ol>
       </nav>
   </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            {{ Form::open(array('route' => ['cgEnvelope/update', $envelope->envelope_id], 'id' => 'gyronimo')) }}
                <div class="bg-boxshadow">
                    <div class="row">
                      <div class="col-sm-6">
                        <div class="creat-new">
                            CG Envelope Name <input type="text" class="sync" placeholder="Enter CG Envelope name" name="envelope_name" value="{{@$envelope->envelope_name}}">
                            @if ($errors->has('envelope_name'))
                                <div class="error" style="color: red">{{ $errors->first('envelope_name') }}</div>
                            @endif
                        </div>
                      </div>
                      <div class="col-sm-6">
                        <div class="creat-new">
                          Remark <input type="text" class="sync" placeholder="Enter remark" name="remark" value="{{@$envelope->remark}}">
                        </div>
                      </div>
                    </div>
                    <div class="ibox-content from-block mb-30">
                        <div class="row">
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="order_id">Aircraft Type</label>
                                    <select data-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="aircraft_type">
                                        @foreach($aircraft as $aircraftData)
                                        @php($selected = '')
                                            @if($envelope->aircraft_type === $aircraftData->aircraft_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$aircraftData->aircraft_id}}" {{$selected}}>{{$aircraftData->aircraft_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label">Manufacturer</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox2" name="manufacturer">
                                        @foreach($manufacturer as $manufacturerData)
                                        @php($selected = '')
                                            @if($envelope->manufacturer === $manufacturerData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$manufacturerData->id}}" {{$selected}}> {{$manufacturerData->manufacturer_name}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Model</label>
                                    <select data-style="btn-select-tag" class="form-control mb-15 sync" id="dbox" name="model">
                                        @foreach($model as $modelData)
                                        @php($selected = '')
                                            @if($envelope->model === $modelData->id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$modelData->id}}" {{$selected}}>{{$modelData->model_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Variant</label>
                                     <select cdata-style="btn-select-tag" class="selectpicker form-control mb-15 sync" name="variant">
                                        @foreach($variant as $variantData)
                                        @php($selected = '')
                                            @if($envelope->variant === $variantData->variant_id)
                                            @php($selected = 'selected')
                                            @endif
                                            <option value="{{$variantData->variant_id}}" {{$selected}}>{{$variantData->variant_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="col-form-label" for="customer">Unit</label>
                                     <select cdata-style="btn-select-tag" class="form-control mb-15 sync" name="unit">
                                       <option <?php if($envelope->unit == 'kg') echo 'selected="selected"'; ?>>kg</option>
                                       <option <?php if($envelope->unit == 'lbs') echo 'selected="selected"'; ?>>lbs</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
  <div class="row">
    <div class="col-12">
      <div class="product-list--area bg-boxshadow">
        <div id='gyronimo-handle'></div>
        <div class="box-block">
         <div class="row">
           <div class="col-sm-2">
             <div class="form-group">
               <label class="col-form-label">BOX Width</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter width px" id="box-width-input" name="box_width" value="{{$envelope->box_width}}">
             </div>
          </div>
          <div class="col-sm-2">
            <div class="form-group">
               <label class="col-form-label">Box height</label>
               <input class="form-control mb-15 sync" type="number" placeholder="Enter height px" id="box-height-input" name="box_height" value="{{$envelope->box_height}}">
             </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-7">
              <div id="chartContainer" style="height: 270px; width: 100%;">
              </div>
          </div>
          <div class="col-md-5">
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                   X Min:
                   <input id="xMin" type="number" value="1000" step="any" placeholder="Enter X-Min" class="form-control" name="x_min">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   X Max:
                   <input id="xMax" type="number" value="5000" step="any" placeholder="Enter X-Max" class="form-control" name="x_max">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   X Line:
                   <input id="xLine" type="number" value="3" step="any" placeholder="Enter X-Line" class="form-control" name="x_line">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y Min:
                   <input id="yMin" type="number" value="1000" step="any" placeholder="Enter Y-Min" class="form-control" name="y_min">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y Max:
                   <input id="yMax" type="number" value="5000" step="any" placeholder="Enter Y-Max" class="form-control" name="y_max">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                   Y Line:
                   <input id="yLine" type="number" value="4" step="any" placeholder="Enter Y-Line" class="form-control" name="y_line">
                </div>
              </div>
            <div class="col-md-4">
              <div class="form-group">
                 X Value:
                 <input id="xValue" type="number" step="any" placeholder="Enter X-Value" class="form-control" name="x_value[]">
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                 Y Value:
                 <input id="yValue" type="number" step="any" placeholder="Enter Y-Value" class="form-control" name="y_value[]">
              </div>
            </div>
            <div class="col-md-6">
                <button id="renderButton" class="btn btn-info" type="button">Add Point</button>
            </div>
          </div>
          <!-- <div class="row">
            <div class="col-md-12 hidden" id="chartTableHeader">
              <h6>Points</h6>
              <div class="row">
              <div class="col-md-4">
                <b>X</b>
              </div>
              <div class="col-md-4">
                <b>Y</b>
              </div>
              <div class="col-md-4">
                <b>Action</b>
              </div>
            </div>
            </div>
          </div> -->
          <div class="row">
            <div class="col-md-12 hidden" id="chartTableHeader">
              <h6>Points</h6>
              <table class="table table-responsive">
                <thead>
                <th>X</th>
                <th>Y</th>
                <th>Action</th>
              </thead>
              <tbody id="chartTable">

              </tbody>
              </table>
            </div>
          </div>
          <!-- <div class="row" id="chartTable">
          </div> -->
          </div>
        </div>
     </div>
     <div class="row">
         <div class="col-sm-12">
             <div class="button-block">
               <button onclick="location.href='{{ route('cgEnvelope') }}'" class="btn btn-primary btn-md" type="button">Cancel</button>
               <button class="btn btn-info btn-md" type="submit" id="save">Save</button>
             </div>
         </div>
     </div>
          </div>
        </div>
    </div>
</form>
</div>
<script src="{{asset('js/jquery-1.12.4.js')}}"></script>
<script type="text/javascript" src="{{asset('js/jquery-ui.js')}}"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
var synced = true;
var collapseCounter = 0;
var store = new Array();
var frame = new Array();
var dps = new Array();
var dpsStore = new Array();
var appUrl = 	window.location.origin ? window.location.origin + '/' : window.location.protocol + '/' + window.location.host;
var settings = {
  configId: $('#config').val(),
  lineWidthPx: 6
};

// syncStore();
//
window.onbeforeunload = function (e) {
    if(!synced) {
      var e = e || window.event;
      if (e) {
        e.returnValue = 'Data not saved yet!';
      }
      return 'Data not saved yet!';
    }
};
//
$(document).ready(function () {
  $(document).on('keyup change', '.sync', function () {
    synced = false;
  });

  $('#gyronimo').on("submit", function(e) {
    // console.log(dps);
     var form = $(this);
     // var data_parse = $.parseJSON(dps);
     e.preventDefault();
     $.ajaxSetup({
       headers: {
         'X-CSRF-TOKEN':  $('meta[name="csrf-token"]').attr('content')
       }
     });
     $.ajax({
        type: "POST",
        cache: false,
        url: form.attr('action'),
        data: form.serialize(),
        processData: true,
        dataType: "json",
        success: function (json) {
          synced = true;
          $('#gyronimo-handle').html(json.message);
          $('#gyronimo-handle').removeClass("hidden");
          $('#gyronimo-handle').addClass("alert alert-dark-success");
          setTimeout(function () {
            $('#gyronimo-handle').addClass("hidden");
          }, 5000);
        },
        error: function () {
          $('#gyronimo-handle').html('Something went wrong!');
          $('#gyronimo-handle').removeClass("hidden");
          $('#gyronimo-handle').addClass("alert alert-dark-danger");
          setTimeout(function () {
            $('#gyronimo-handle').addClass("hidden");
          }, 5000);
        }
    });
  });
});

function syncStore() {
  document.getElementById("store").value = JSON.stringify(window.store);
}
</script>

            {{ Form::close() }}
            <script type="text/javascript">

        window.onload = function() {
            var xMin;
            var xMax;
            var yMin;
            var yMax;
            var chart = new CanvasJS.Chart("chartContainer", {
                backgroundColor: "black",
                axisX:{
                    title: "X Axis",
                    labelFontColor: "white",
                    minimum: xMin,
                    maximum: xMax,
                    gridThickness: 1,
                    // interval:

                },
                axisY:{
                    title: "Y Axis",
                    labelFontColor: "white",
                    minimum: yMin,
                    maximum: yMax,
                    // interval: 2000
                },
                title: {
                    text: "CG Envelope"
                },
                data: [{
                    type: "line",
                    dataPoints: window.dps
                }]
            });

            function addDataPointsAndRender() {
                xValue = Number(document.getElementById("xValue").value);
                yValue = Number(document.getElementById("yValue").value);
                xMin = document.getElementById("xMin").value;
                xMax = document.getElementById("xMax").value;
                yMin = document.getElementById("yMin").value;
                yMax = document.getElementById("yMax").value;
                xLine = document.getElementById("xLine").value;
                yLine = document.getElementById("yLine").value;
                xSub = xMax - xMin;
                ySub = yMax - yMin;
                xSum =  + Number(xLine) + 1;
                ySum =  + Number(yLine) + 1;
                xInterval = xSub / xSum;
                yInterval = ySub / ySum;
                chart.options.axisX.minimum = xMin;
                chart.options.axisX.maximum = xMax;
                chart.options.axisY.minimum = yMin;
                chart.options.axisY.maximum = yMax;
                chart.options.axisX.interval = xInterval;
                chart.options.axisY.interval = yInterval;

                window.dpsStore.push({
                  x: xValue,
                  y: yValue
                });
                window.dps.length = 0;
                window.dpsStore.forEach(function (value) {
                  window.dps.push(value);
                });
                window.frame.push({
                  xMin: xMin,
                  xMax: xMax,
                  yMin: yMin,
                  yMax: yMax,
                })

                var count = window.dpsStore.length;
                if (count > 2) {
                  var close = {
                      x: window.dpsStore[0].x,
                      y: window.dpsStore[0].y
                  };
                  window.dps.push(close);
                }
                chartDataStore();
                chart.render();
            }

            function chartDataStore(){
              $('#chartTableHeader').removeClass('hidden');
              $("#chartTable").html("");
              window.dpsStore.forEach(function (value) {
                $("#chartTable").append("<tr><td contenteditable='false'>"+value.x+"</td><td contenteditable='false'>"+value.y+"</td><td><a  id='editItem' class='editbtn'>Edit </a> | <a href='#'> Delete </a></tr>");
              });
            }
            $('.table-responsive').on('click','#editItem', function () {
              	var $this = $(this);
              	var tds = $this.closest('tr').find('td').filter(function() {
                var trElem = $(this).closest("tr");
  		          var firstTd = $(trElem).children("td")[0];
  		          var secondTd = $(trElem).children("td")[1];
  		          var firstValue = $(firstTd).text();
  		          var secondValue = $(secondTd).text();
              		return $(this).find('.editbtn').length === 0;
              	});
              	if ($this.html() === 'Edit') {

              		$this.html('Save');
              		tds.prop('contenteditable', true);
              		tds.css({'border':'1px solid grey'});
              	}
                else if($this.html() === 'Save'){
                  chartDataStore();
                } else {
              		$this.html('Edit');
              		tds.prop('contenteditable', false);
                  tds.css({'border':'0px'});
              	}
              });

              function manageChart(action, data, id)
            // $('.table-responsive').on('click','#editItem', function () {
            //   var currentTD = $(this).parents('tr').find('td');
            //   var trElem = $(this).closest("tr");
		        //   var firstTd = $(trElem).children("td")[0];
		        //   var secondTd = $(trElem).children("td")[1];
		        //   var firstValue = $(firstTd).text();
		        //   var secondValue = $(secondTd).text();
            //   if ($(this).html() == 'Edit') {
            //       $.each(currentTD, function () {
            //           $(this).prop('contenteditable', true);
            //           currentTD.css({' border':'3px solid green'});
            //       });
            //   }else {
            //       $.each(currentTD, function () {
            //           $(this).prop('contenteditable', false)
            //       });
            //   }
            //   $(this).html($(this).html() == 'Edit' ? 'Save' : 'Edit')
            //
            // });
            var renderButton = document.getElementById("renderButton");
            renderButton.addEventListener("click", addDataPointsAndRender);
            // addDataPointsAndRender();
        }
    </script>
    <script type="text/javascript" src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
  </div>
</div>
@endsection
