@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
    <div class="container-fluid">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                <a href="#">
                  @if(isset($user))
                  Edit User
                  @else
                  Create User
                  @endif
                </a></li>
                </li>
            </ol>
        </nav>
    </div>
</div>
        <div class="row">
            <div class="col-lg-12">
            @if(isset($user))
            {{ Form::open(array('route' => ['update',$user->id],'files'=>true)) }}
            @endif
            {{ Form::open(array('route' => 'store','files'=>true)) }}
                <div class="ibox bg-boxshadow min-height mb-50">
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label"> First Name </label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="fnm" placeholder="Enter first name" name="first_name" value="{{@$user->first_name}}">
                          @if ($errors->has('first_name'))
                              <div class="error" style="color: red">{{ $errors->first('first_name') }}</div>
                          @endif
                      </div>
                  </div>
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label"> Last Name </label>
                      <div class="col-sm-12">
                          <input type="text" class="form-control" id="lnm" placeholder="Enter last name" name="last_name" value="{{@$user->last_name}}">
                          @if ($errors->has('last_name'))
                              <div class="error" style="color: red">{{ $errors->first('last_name') }}</div>
                          @endif
                      </div>
                  </div>
                  <div class="form-group row">
                      <label class="col-sm-12 col-form-label"> Address </label>
                      <div class="col-sm-12">
                        <textarea class="form-control" id="address" placeholder="Enter address" name="address">{{@$user->address}}</textarea>
                          @if ($errors->has('address'))
                              <div class="error" style="color: red">{{ $errors->first('address') }}</div>
                          @endif
                      </div>
                  </div>
                  <div class="ibox-content">

                            <div class="form-group row">
                                <label class="col-sm-12 col-form-label"> Email </label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control" id="email" placeholder="Enter Email Id" name="email" value="{{@$user->email}}">
                                    @if ($errors->has('email'))
                                        <div class="error" style="color: red">{{ $errors->first('email') }}</div>
                                    @endif
                                </div>
                            </div>
                            @if(!isset($user))
                            <div class="form-group row">
                                <label class="col-sm-12 col-form-label"> Password </label>
                                <div class="col-sm-12">
                                    <input type="password" class="form-control" id="pwd" placeholder="Enter Password" name="password" value="{{@$user->password}}">
                                    @if ($errors->has('password'))
                                        <div class="error" style="color: red">{{ $errors->first('password') }}</div>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-sm-12 col-form-label">Confirm  Password </label>
                                <div class="col-sm-12">
                                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Enter Confirm Password">
                                    @if ($errors->has('confirm password'))
                                        <div class="error" style="color: red">{{ $errors->first('confirm password') }}</div>
                                    @endif
                                </div>
                            </div>

                            @endif
                            <div class="form-group row">
                                <label class="col-sm-12 col-form-label"> Phone </label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control" id="phone" placeholder="Enter phone" name="phone" value="{{@$user->phone}}">
                                    @if ($errors->has('phone'))
                                        <div class="error" style="color: red">{{ $errors->first('phone') }}</div>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-sm-12 col-form-label"> Language </label>
                                <div class="col-sm-12">
                                    <input type="text" class="form-control" id="language" placeholder="Enter language" name="language" value="{{@$user->language}}">
                                    @if ($errors->has('language'))
                                        <div class="error" style="color: red">{{ $errors->first('language') }}</div>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                              <label class="col-sm-12 col-form-label" for="image">Image</label>
                              <div class="col-sm-12">
                              {!! Form::file('image', array('class' => 'form-control')) !!}
                              @if ($errors->has('image'))
                              <div class="error" style="color: red">{{ $errors->first('image') }}</div>
                              @endif
                            </div>
                            </div>


                    </div>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            {{ Form::close() }}
            </div>
        </div>
@endsection
