@extends('admin.layouts.master')
@section('content')
<div class="breadcrumb-area">
   <div class="container-fluid">
       <nav aria-label="breadcrumb">
           <ol class="breadcrumb">
               <li class="breadcrumb-item"><a href="#">User List</a></li>               
               </li>
           </ol>
       </nav>
   </div>
</div>
<div class="container-fluid">
	<div class="row">
        <div class="col-12">
            <div class="product-list--area bg-boxshadow">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox">
                            <div class="ibox-content">
                                <table class="footable table table-stripped toggle-arrow-tiny" data-page-size="15">
                                    <thead>
                                        <tr>
                                            <th data-toggle="true">Id</th>
                                            <th data-toggle="true">Name</th>
                                            <th data-toggle="true">Email</th>
																						<th data-toggle="true">Phone</th>
                                            <th class="text-right" data-sort-ignore="true">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    	@foreach($user as $b)
	                                        <tr>
																					<td>{{ $b->id }}</td>
																					<td>{{$b->first_name .' '. $b->last_name }}</td>
																					<td>{{$b->email}}</td>
																					<td>{{$b->phone}}</td>
	                                        <td class="text-right">
	                                                <div class="btn-group">
	                                                    <div class="btn-group">
		                                                    <a class="btn btn-primary btn-sm" href="{{route('show',$b->id)}}"> View </a>
		                                                    <a class="btn btn-success btn-sm" href="{{route('edit',$b->id)}}"> Edit </a>
		                                                    <a class="btn btn-danger btn-sm" href="{{route('delete',$b->id)}}"> Delete </a>
	                                                	</div>
	                                            	</div>
	                                            </td>
	                                        </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="7">
                                                <ul class="pagination float-right mt-30"></ul>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script type="text/javascript">
$(document).ready(function(){
	$('.table').on('click','.delete_row', function(){
		var id = $(this).attr('data-id');
		$(this).closest('tr').remove();
		$.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
        $.ajax(
    	{
        url: "delete/"+id,
        type: 'get', // replaced from put
        dataType: "JSON",
        success: function (response)
        {
            console.log(response); // see the reponse sent
        },
        error: function(xhr) {
         console.log(xhr.responseText); // this line will save you tons of hours while debugging
        // do something here because of error
       }
    });

});

});
</script>
@endsection
